// Title      : Posts.java
// Author     : James Baird
// Created    : Monday, 23rd June 2003
// Description: Representation of a post and its potential replies

import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Posts extends DefaultHandler
{
  Posts(Group group, int id)
  {
    this.group = group;
    this.id = id;
  }
  
  public void startDocument() throws SAXException
  {
    state = "seekInitial";

    replies = new Vector();
  }
  
  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
  {
    if (state.startsWith("seek"))
      if (qName.equals("post"))
      {
        if (state.equals("seekInitial") && attributes.getValue("id").equals(Integer.toString(id)))
        {      
          post = new Post(group, id);
        
          post.startDocument();

          state = "extractInitial";
        }
        else if (state.equals("seekReply") && attributes.getValue("subject").startsWith("Re:") && attributes.getValue("subject").indexOf(initial.getSubject()) != -1)
        {
          post = new Post(group, Integer.parseInt(attributes.getValue("id")));
          
          post.startDocument();

          state = "extractReply";
        }
      }
      
    if (state.startsWith("extract"))
      post.startElement(uri, localName, qName, attributes);
  }
  
  public void endElement(String uri, String localName, String qName) throws SAXException
  {
    if (state.startsWith("extract"))
      post.endElement(uri, localName, qName);
      
    if (qName.equals("post"))
    {
      if (state.equals("extractInitial"))
      {
        initial = post;
        
        state = "seekReply";
      }
      else if (state.equals("extractReply"))
      {
        replies.addElement(post);
        
        state = "seekReply";
      }
    }
  }
  
  public void characters(char[] ch, int start, int length) throws SAXException
  {
    if (state.startsWith("extract"))
      post.characters(ch, start, length);
  }

  public String toString()
  {
    StringBuffer sb = new StringBuffer("");
    
    sb.append("*** INITAL POST" + System.getProperty("line.separator"));
    sb.append(initial);
    sb.append(System.getProperty("line.separator"));

    sb.append("*** REPLIES" + System.getProperty("line.separator"));
    for (int i = 0; i < replies.size(); i++)
    {
      Post p = (Post)replies.elementAt(i);
      
      sb.append("*** LIKELIHOOD = " + likelihood(initial, p) * 100.0 + System.getProperty("line.separator"));
      sb.append(p);

      sb.append(System.getProperty("line.separator"));
    }
    
    return sb.toString();
  }

  private double likelihood(Post initial, Post reply)
  {
    double result = 0.0;

    Vector initialBody = initial.getBody();
    Vector replyBody = reply.getBody();

    int quoteCount = 0;

    for (int i = 0; i < replyBody.size(); i++)
    {
      String replyLine = (String)replyBody.elementAt(i);
      replyLine.trim();

      if (replyLine.startsWith(">") && replyLine.length() > 1)
      {
        quoteCount++;

        for (int j = 0; j < initialBody.size(); j++)
        {
          String initialLine = (String)initialBody.elementAt(j);
          initialLine.trim();

          if (!initialLine.equals("") && replyLine.indexOf(initialLine) != -1)
          {
            result += 1.0;

            break;
          }
        }
      }
    }

    if (quoteCount != 0)
      result /= quoteCount;

    return result;
  }

  private Group group;
  private int id;
  private Post post;
  private Post initial;
  private Vector replies;
  
  private String state;
}
